/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.formatters;

import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DataFormatter;
import com.ibm.ui.framework.IllegalUserDataException;

public class BinaryFormatter
extends DataFormatter {
    private static final String TRACE_MASKD = "XFRMBIND";
    private static final String TRACE_MASKF = "XFRMBINF";
    private static final String TRACE_MASKT = "XFRMBINT";
    protected int padsize = 0;
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);
    protected LocalizableText invalidLengthMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badlength", null);
    protected LocalizableText msgTitle = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.title", null);

    public String format(Object obj) {
        String intString = "";
        try {
            intString = (String)obj;
            Trace.trace(TRACE_MASKF, "in BinaryFormatter:format " + obj);
            if (this.padsize > 0 && intString.length() < this.padsize) {
                while (intString.length() < this.padsize) {
                    intString = "0" + intString;
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error converting '" + obj + "' to a long, defaulting to 0");
            intString = "0";
        }
        return intString.toUpperCase();
    }

    public Object parse(String source) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "in BinaryFormatter:parse " + source);
        if (this.padsize > 0 && source.length() > this.padsize) {
            throw new IllegalUserDataException(this.invalidLengthMsg.toString());
        }
        try {
            int sourceLength = source.length();
            for (int i = 0; i < sourceLength; ++i) {
                if (i == sourceLength) {
                    if (Short.valueOf(source.substring(i)) <= 1) continue;
                    Trace.trace(TRACE_MASKD, "bad data entered ");
                    throw new IllegalUserDataException(this.invalidValueMsg.toString());
                }
                if (Short.valueOf(source.substring(i, i + 1)) <= 1) continue;
                Trace.trace(TRACE_MASKD, "bad data entered 2");
                throw new IllegalUserDataException(this.invalidValueMsg.toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString());
        }
        return source;
    }

    public void setPadsize(int i) {
        this.padsize = i;
    }

    public int getPadsize() {
        return this.padsize;
    }
}

